definition module StdMaybe

//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdMaybe defines the Maybe type.
//	********************************************************************************

::	Maybe x
	=	Just x
	|	Nothing

isJust		:: !(Maybe .x) -> Bool		// case @1 of (Just _) -> True; _ -> False
isNothing	:: !(Maybe .x) -> Bool		// not o isJust
fromJust	:: !(Maybe .x) -> .x		// \(Just x) -> x

// for possibly unique elements

u_isJust	:: !(Maybe .x) -> (!Bool, !Maybe .x)
u_isNothing	:: !(Maybe .x) -> (!Bool, !Maybe .x)
